/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
/*
 * Aliaksei_Budnikau
 * Date: Oct 24, 2002
 */
package org.silverpeas.core.pdc.subscription.service;

import java.util.List;

import org.silverpeas.core.pdc.subscription.model.PdcSubscription;

import org.silverpeas.core.pdc.classification.Value;

public interface PdcSubscriptionService {

  /**
   * @param userId
   * @return a list of <code>PDCSubscriptions</code> finded by id provided
   */
  public List<PdcSubscription> getPDCSubscriptionByUserId(int userId);

  public PdcSubscription getPDCSubsriptionById(int id);

  /**
   * @param subscription
   * @return new autogenerated PdcSubscription id
   */
  public int createPDCSubscription(PdcSubscription subscription);

  public void updatePDCSubscription(PdcSubscription subscription);

  public void removePDCSubscriptionById(int id);

  public void removePDCSubscriptionById(int[] ids);

  /**
   * This method check is any subscription that match criterias provided and sends notification if
   * succeed
   *
   * @param classifyValues Linst of ClassifyValues to be checked
   * @param componentId component where classify event occures
   * @param silverObjectid object that was classified
   */
  public void checkSubscriptions(List<? extends Value> classifyValues, String componentId,
      int silverObjectid);

  /**
   * Implements PdcSubscription check for value deletion. It deletes all references to the path
   * containing this value from PdcSubscription module DB
   *
   * @param axisId the axis to be checked
   * @param axisName the name of the axis
   * @param oldPath old path that would be removed soon
   * @param newPath new path. That will be places instead of old for this axis
   * @param pathInfo should contains PdcBm.getFullPath data structure
   */
  public void checkValueOnDelete(int axisId, String axisName, List<String> oldPath,
      List<String> newPath, List<org.silverpeas.core.pdc.pdc.model.Value> pathInfo);

  /**
   * Implements PdcSubscription check for axis deletion. It deletes all references to this axis from
   * PdcSubscription module DB
   *
   * @param axisId the axis to be checked
   * @param axisName the name of the axis
   */
  public void checkAxisOnDelete(int axisId, String axisName);
}
